/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.io;

import com.google.common.annotations.Beta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.Checksum;
import org.python.google.common.base.Preconditions;
import org.python.google.common.io.ByteArrayDataInput;
import org.python.google.common.io.ByteArrayDataOutput;
import org.python.google.common.io.ByteProcessor;
import org.python.google.common.io.Closeables;
import org.python.google.common.io.InputSupplier;
import org.python.google.common.io.LimitInputStream;
import org.python.google.common.io.MultiInputStream;
import org.python.google.common.io.OutputSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class ByteStreams {
    private static final int BUF_SIZE = 4096;

    private ByteStreams() {
    }

    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(byte[] byArray) {
        return ByteStreams.newInputStreamSupplier(byArray, 0, byArray.length);
    }

    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(final byte[] byArray, final int n, final int n2) {
        return new InputSupplier<ByteArrayInputStream>(){

            @Override
            public ByteArrayInputStream getInput() {
                return new ByteArrayInputStream(byArray, n, n2);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] byArray, OutputSupplier<? extends OutputStream> outputSupplier) throws IOException {
        Preconditions.checkNotNull(byArray);
        boolean bl = true;
        OutputStream outputStream = outputSupplier.getOutput();
        try {
            outputStream.write(byArray);
            bl = false;
        }
        finally {
            Closeables.close(outputStream, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputSupplier<? extends InputStream> inputSupplier, OutputSupplier<? extends OutputStream> outputSupplier) throws IOException {
        boolean bl = true;
        InputStream inputStream = inputSupplier.getInput();
        try {
            long l;
            OutputStream outputStream = outputSupplier.getOutput();
            try {
                long l2 = ByteStreams.copy(inputStream, outputStream);
                bl = false;
                l = l2;
            }
            catch (Throwable throwable) {
                Closeables.close(outputStream, bl);
                throw throwable;
            }
            Closeables.close(outputStream, bl);
            return l;
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputSupplier<? extends InputStream> inputSupplier, OutputStream outputStream) throws IOException {
        boolean bl = true;
        InputStream inputStream = inputSupplier.getInput();
        try {
            long l = ByteStreams.copy(inputStream, outputStream);
            bl = false;
            long l2 = l;
            return l2;
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static long copy(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        long l = 0L;
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                l += (long)writableByteChannel.write(byteBuffer);
            }
            byteBuffer.clear();
        }
        return l;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteStreams.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputSupplier<? extends InputStream> inputSupplier) throws IOException {
        boolean bl = true;
        InputStream inputStream = inputSupplier.getInput();
        try {
            byte[] byArray = ByteStreams.toByteArray(inputStream);
            bl = false;
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    public static ByteArrayDataInput newDataInput(byte[] byArray) {
        return new ByteArrayDataInputStream(byArray);
    }

    public static ByteArrayDataInput newDataInput(byte[] byArray, int n) {
        Preconditions.checkPositionIndex(n, byArray.length);
        return new ByteArrayDataInputStream(byArray, n);
    }

    public static ByteArrayDataOutput newDataOutput() {
        return new ByteArrayDataOutputStream();
    }

    public static ByteArrayDataOutput newDataOutput(int n) {
        Preconditions.checkArgument(n >= 0, "Invalid size: %s", n);
        return new ByteArrayDataOutputStream(n);
    }

    public static long length(InputSupplier<? extends InputStream> inputSupplier) throws IOException {
        long l = 0L;
        boolean bl = true;
        InputStream inputStream = inputSupplier.getInput();
        try {
            while (true) {
                long l2;
                if ((l2 = inputStream.skip(Integer.MAX_VALUE)) == 0L) {
                    if (inputStream.read() == -1) {
                        bl = false;
                        long l3 = l;
                        return l3;
                    }
                    ++l;
                    continue;
                }
                l += l2;
            }
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    public static boolean equal(InputSupplier<? extends InputStream> inputSupplier, InputSupplier<? extends InputStream> inputSupplier2) throws IOException {
        byte[] byArray = new byte[4096];
        byte[] byArray2 = new byte[4096];
        boolean bl = true;
        InputStream inputStream = inputSupplier.getInput();
        try {
            InputStream inputStream2 = inputSupplier2.getInput();
            try {
                while (true) {
                    int n;
                    int n2;
                    if ((n2 = ByteStreams.read(inputStream, byArray, 0, 4096)) != (n = ByteStreams.read(inputStream2, byArray2, 0, 4096)) || !Arrays.equals(byArray, byArray2)) {
                        bl = false;
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (n2 == 4096) continue;
                    bl = false;
                    boolean bl3 = true;
                    return bl3;
                }
            }
            finally {
                Closeables.close(inputStream2, bl);
            }
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        ByteStreams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (ByteStreams.read(inputStream, byArray, n, n2) != n2) {
            throw new EOFException();
        }
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 == 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException();
                }
                --l;
                continue;
            }
            l -= l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readBytes(InputSupplier<? extends InputStream> inputSupplier, ByteProcessor<T> byteProcessor) throws IOException {
        byte[] byArray = new byte[4096];
        boolean bl = true;
        InputStream inputStream = inputSupplier.getInput();
        try {
            int n;
            do {
                if ((n = inputStream.read(byArray)) != -1) continue;
                bl = false;
                break;
            } while (byteProcessor.processBytes(byArray, 0, n));
            T t = byteProcessor.getResult();
            return t;
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    public static long getChecksum(InputSupplier<? extends InputStream> inputSupplier, final Checksum checksum) throws IOException {
        return ByteStreams.readBytes(inputSupplier, new ByteProcessor<Long>(){

            @Override
            public boolean processBytes(byte[] byArray, int n, int n2) {
                checksum.update(byArray, n, n2);
                return true;
            }

            @Override
            public Long getResult() {
                long l = checksum.getValue();
                checksum.reset();
                return l;
            }
        });
    }

    public static byte[] getDigest(InputSupplier<? extends InputStream> inputSupplier, final MessageDigest messageDigest) throws IOException {
        return ByteStreams.readBytes(inputSupplier, new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] byArray, int n, int n2) {
                messageDigest.update(byArray, n, n2);
                return true;
            }

            @Override
            public byte[] getResult() {
                return messageDigest.digest();
            }
        });
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) != -1; n3 += n4) {
        }
        return n3;
    }

    public static InputSupplier<InputStream> slice(final InputSupplier<? extends InputStream> inputSupplier, final long l, final long l2) {
        Preconditions.checkNotNull(inputSupplier);
        Preconditions.checkArgument(l >= 0L, "offset is negative");
        Preconditions.checkArgument(l2 >= 0L, "length is negative");
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                InputStream inputStream = (InputStream)inputSupplier.getInput();
                if (l > 0L) {
                    try {
                        ByteStreams.skipFully(inputStream, l);
                    }
                    catch (IOException iOException) {
                        Closeables.closeQuietly(inputStream);
                        throw iOException;
                    }
                }
                return new LimitInputStream(inputStream, l2);
            }
        };
    }

    public static InputSupplier<InputStream> join(final Iterable<? extends InputSupplier<? extends InputStream>> iterable) {
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                return new MultiInputStream(iterable.iterator());
            }
        };
    }

    public static InputSupplier<InputStream> join(InputSupplier<? extends InputStream> ... inputSupplierArray) {
        return ByteStreams.join(Arrays.asList(inputSupplierArray));
    }

    private static class ByteArrayDataInputStream
    implements ByteArrayDataInput {
        final DataInput input;

        ByteArrayDataInputStream(byte[] byArray) {
            this.input = new DataInputStream(new ByteArrayInputStream(byArray));
        }

        ByteArrayDataInputStream(byte[] byArray, int n) {
            this.input = new DataInputStream(new ByteArrayInputStream(byArray, n, byArray.length - n));
        }

        public void readFully(byte[] byArray) {
            try {
                this.input.readFully(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public void readFully(byte[] byArray, int n, int n2) {
            try {
                this.input.readFully(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public int skipBytes(int n) {
            try {
                return this.input.skipBytes(n);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException eOFException) {
                throw new IllegalStateException(eOFException);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    private static class ByteArrayDataOutputStream
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputSteam;

        ByteArrayDataOutputStream() {
            this(new ByteArrayOutputStream());
        }

        ByteArrayDataOutputStream(int n) {
            this(new ByteArrayOutputStream(n));
        }

        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            this.byteArrayOutputSteam = byteArrayOutputStream;
            this.output = new DataOutputStream(byteArrayOutputStream);
        }

        public void write(int n) {
            try {
                this.output.write(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void write(byte[] byArray) {
            try {
                this.output.write(byArray);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void write(byte[] byArray, int n, int n2) {
            try {
                this.output.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeBoolean(boolean bl) {
            try {
                this.output.writeBoolean(bl);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeByte(int n) {
            try {
                this.output.writeByte(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeBytes(String string) {
            try {
                this.output.writeBytes(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeChar(int n) {
            try {
                this.output.writeChar(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeChars(String string) {
            try {
                this.output.writeChars(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeDouble(double d) {
            try {
                this.output.writeDouble(d);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeFloat(float f) {
            try {
                this.output.writeFloat(f);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeInt(int n) {
            try {
                this.output.writeInt(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeLong(long l) {
            try {
                this.output.writeLong(l);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeShort(int n) {
            try {
                this.output.writeShort(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void writeUTF(String string) {
            try {
                this.output.writeUTF(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public byte[] toByteArray() {
            return this.byteArrayOutputSteam.toByteArray();
        }
    }
}

